const API_URL = 'https://trago.io/playspace/youtube-downloader/api/cookies';

document.getElementById('sync').addEventListener('click', async () => {
  const btn = document.getElementById('sync');
  const status = document.getElementById('status');

  btn.disabled = true;
  btn.textContent = 'Syncing...';
  status.className = 'status';

  try {
    // Get all YouTube cookies
    const cookies = await chrome.cookies.getAll({ domain: '.youtube.com' });

    if (cookies.length === 0) {
      throw new Error('No YouTube cookies found. Please log in to YouTube first.');
    }

    // Convert to Netscape cookie format
    const cookieText = cookies.map(c => {
      const domain = c.domain.startsWith('.') ? c.domain : '.' + c.domain;
      const flag = c.domain.startsWith('.') ? 'TRUE' : 'FALSE';
      const secure = c.secure ? 'TRUE' : 'FALSE';
      const expiry = c.expirationDate ? Math.floor(c.expirationDate) : '0';
      return `${domain}\t${flag}\t${c.path}\t${secure}\t${expiry}\t${c.name}\t${c.value}`;
    }).join('\n');

    // Send to server
    const response = await fetch(API_URL, {
      method: 'POST',
      headers: { 'Content-Type': 'text/plain' },
      body: cookieText
    });

    if (!response.ok) {
      throw new Error('Failed to sync cookies');
    }

    status.textContent = 'Synced! You can now download any video.';
    status.className = 'status success';
    btn.textContent = 'Sync YouTube Session';

  } catch (error) {
    status.textContent = error.message;
    status.className = 'status error';
    btn.textContent = 'Sync YouTube Session';
  }

  btn.disabled = false;
});
